<?php
// /src/helpers/helperFunctions.php

function json_response($data, int $status = 200): void {
    http_response_code($status);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

function fail(string $message, int $status = 400, array $meta = []): void {
    json_response([
        'data' => null,
        'meta' => array_merge([
            'ok' => false,
            'error' => $message,
        ], $meta)
    ], $status);
}

function get_param(string $key, $default = null) {
    if (isset($_GET[$key]) && $_GET[$key] !== '') return $_GET[$key];
    if (isset($_POST[$key]) && $_POST[$key] !== '') return $_POST[$key];
    return $default;
}

function bearer_token(): ?string {
    // XAMPP/Apache بعضی وقت‌ها Authorization را داخل HTTP_AUTHORIZATION نمی‌گذارد.
    $h = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
    if (!$h) $h = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? '';

    if (!$h && function_exists('getallheaders')) {
        $headers = getallheaders();
        foreach ($headers as $k => $v) {
            if (strtolower($k) === 'authorization') {
                $h = $v;
                break;
            }
        }
    }

    if (!$h) return null;
    if (preg_match('/Bearer\s+(.+)/i', $h, $m)) return trim($m[1]);
    return null;
}

function parse_date(?string $s): ?string {
    if (!$s) return null;
    if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $s)) return null;
    return $s;
}
