<?php
// /src/helpers/helperFunctions.php

// CORS (place at top of helperFunctions.php)
function cors_handle(): void {
    $origin = $_SERVER['HTTP_ORIGIN'] ?? '';

    // دقیق و whitelist شده
    $allowed = [
        'https://bipanel.infoprotech.ir',
        'http://localhost:5173',
        'http://127.0.0.1:5173',
    ];

    // if ($origin && in_array($origin, $allowed, true)) {
    //     header("Access-Control-Allow-Origin: $origin");
    //     header("Vary: Origin");
    //     header("Access-Control-Allow-Credentials: true");
    //     header("Access-Control-Allow-Methods: GET,POST,PUT,PATCH,DELETE,OPTIONS");
    //     header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, Accept");
    // }

    // پاسخ preflight
    // if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') {
    //     http_response_code(204);
    //     exit;
    // }
}

cors_handle();

function json_response($data, int $status = 200): void {
    http_response_code($status);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

function fail(string $message, int $status = 400, array $meta = []): void {
    json_response([
        'data' => null,
        'meta' => array_merge([
            'ok' => false,
            'error' => $message,
        ], $meta)
    ], $status);
}

function get_param(string $key, $default = null) {
    if (isset($_GET[$key]) && $_GET[$key] !== '') return $_GET[$key];
    if (isset($_POST[$key]) && $_POST[$key] !== '') return $_POST[$key];
    return $default;
}

function bearer_token(): ?string {
    // XAMPP/Apache بعضی وقت‌ها Authorization را داخل HTTP_AUTHORIZATION نمی‌گذارد.
    $h = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
    if (!$h) $h = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? '';

    if (!$h && function_exists('getallheaders')) {
        $headers = getallheaders();
        foreach ($headers as $k => $v) {
            if (strtolower($k) === 'authorization') {
                $h = $v;
                break;
            }
        }
    }

    if (!$h) return null;
    if (preg_match('/Bearer\s+(.+)/i', $h, $m)) return trim($m[1]);
    return null;
}

function parse_date(?string $s): ?string {
    if (!$s) return null;
    if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $s)) return null;
    return $s;
}
