<?php
// /src/config/ai.php
// GapGPT configuration

/**
 * Set your API key via environment variable or hard-code it here (not recommended).
 *
 * ENV:
 *   GAPGPT_API_KEY=...
 *   GAPGPT_BASE_URL=https://gapgpt.app/api/v1/chat/completions
 *   GAPGPT_MODEL=gpt-4.1-mini (example)
 */

function ai_config(): array {
    $key = getenv('GAPGPT_API_KEY');
    if ($key === false) $key = 'sk-0C9w0UMNOWkXJY4uKASHrvuFGo2lzytwYrfd1EVOMGQGq77E';

    $base = getenv('GAPGPT_BASE_URL');
    if ($base === false || trim($base) === '') {
        // Default based on GapGPT site examples found online.
        // If your Platform-v2 uses a different base URL, set GAPGPT_BASE_URL.
        $base = 'https://gapgpt.app/api/v1/chat/completions';
    }

    $model = getenv('GAPGPT_MODEL');
    if ($model === false || trim($model) === '') {
        // Choose a sensible default; override via env.
        $model = 'gpt-4o-mini';
    }

    return [
        'provider' => 'gapgpt',
        'api_key'  => trim($key),
        'base_url' => trim($base),
        'model'    => trim($model),
        'timeout_s'=> 45,
    ];
}
