<?php
// /api/auth/login.php
define('BI_API', true);

require_once __DIR__ . '/../../src/config/db.php';
require_once __DIR__ . '/../../src/helpers/helperFunctions.php';

try {
    $username = trim((string)get_param('username', ''));
    $password = (string)get_param('password', '');

    if ($username === '' || $password === '') fail('username/password required', 400);

    $conn = db_connect();

    $stmt = sqlsrv_query($conn,
        "SELECT TOP 1 UserID, Username, PasswordHash, Role, Province, BrandID, BrandTitle, IsActive
         FROM BI.Users WHERE Username = ?",
        [$username]
    );
    if ($stmt === false) fail('DB error (login)', 500, ['sqlsrv_errors' => sqlsrv_errors()]);


    $u = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
    if (!$u) fail('Invalid credentials', 401);
    if (!(int)$u['IsActive']) fail('User inactive', 403);

    if (!password_verify($password, $u['PasswordHash'])) {
        fail('Invalid credentials', 401);
    }

    $token = bin2hex(random_bytes(32));

    $stmt2 = sqlsrv_query($conn,
        "INSERT INTO BI.UserTokens (Token, UserID, ExpiresAt) VALUES (?, ?, DATEADD(day, 30, SYSDATETIME()))",
        [$token, (int)$u['UserID']]
    );
    if ($stmt2 === false) fail('DB error (token)', 500);

    json_response([
        'data' => [
            'token' => $token,
            'user' => [
                'user_id' => (int)$u['UserID'],
                'username' => $u['Username'],
                'role' => $u['Role'],
                'province' => $u['Province'],
                'brand_id' => $u['BrandID'] !== null ? (int)$u['BrandID'] : null,
                'brand_title' => $u['BrandTitle'],
            ],
        ],
        'meta' => ['ok' => true],
    ]);
} catch (Throwable $e) {
    fail('Server error: ' . $e->getMessage(), 500);
}
