<?php
// /src/helpers/DateRange.php

if (!defined('BI_API')) { exit('No direct script access'); }

/**
 * Resolve date range from month_from/month_to or date_from/date_to.
 * - month_from/month_to format: YYYY-MM
 * - date_from/date_to format: YYYY-MM-DD
 * Returns: [date_from, date_to, date_to_excl, mode]
 */
function resolve_date_range(): array
{
    $month_from = trim((string)get_param('month_from', ''));
    $month_to   = trim((string)get_param('month_to', ''));

    $date_from = parse_date(get_param('date_from'));
    $date_to   = parse_date(get_param('date_to'));

    // priority: month range
    if ($month_from !== '' && $month_to !== '') {
        // month_from/month_to must be YYYY-MM
        if (!preg_match('/^\d{4}\-\d{2}$/', $month_from) || !preg_match('/^\d{4}\-\d{2}$/', $month_to)) {
            fail('Invalid month_from/month_to. Use YYYY-MM', 400);
        }

        $date_from = $month_from . '-01';
        $date_to   = date('Y-m-t', strtotime($month_to . '-01'));
    }

    // fallback: date range or default 90 days
    if (!$date_from || !$date_to) {
        $date_to = date('Y-m-d');
        $date_from = date('Y-m-d', strtotime('-89 days'));
    }

    $date_to_excl = date('Y-m-d', strtotime($date_to . ' +1 day'));

    $mode = ($month_from && $month_to) ? 'month' : (($date_from && $date_to) ? 'date' : 'default');

    return [$date_from, $date_to, $date_to_excl, $mode];
}
