<?php
// /src/config/db.php
// DB connection for SQL Server (sqlsrv)
// NOTE: Adjust credentials here if needed

if (!defined('BI_API')) { define('BI_API', true); }

function db(): array {
    static $cfg;
    if ($cfg) return $cfg;

    $cfg = [
        'server'   => 'localhost',
        // طبق درخواست شما دیتابیس اصلی DarianDW است.
        // اگر روی محیطی جدول‌های BI داخل DarianDW_Dashboard باشند، به صورت خودکار fallback می‌کنیم.
'database' => 'DarianDW_Dashboard',
        'fallback_database' => 'DarianDW_Dashboard',
        'uid'      => 'SH',
        'pwd'      => '1!2@3#4$5%6^',
        'options'  => [
            'CharacterSet' => 'UTF-8',
            'ReturnDatesAsStrings' => true,
            'MultipleActiveResultSets' => true,
        ],
    ];
    return $cfg;
}

function db_connect() {
    $c = db();

    $connect = function(string $dbName) use ($c) {
        return sqlsrv_connect($c['server'], [
            'Database' => $dbName,
            'UID' => $c['uid'],
            'PWD' => $c['pwd'],
            'CharacterSet' => $c['options']['CharacterSet'] ?? 'UTF-8',
            'ReturnDatesAsStrings' => $c['options']['ReturnDatesAsStrings'] ?? true,
            'MultipleActiveResultSets' => $c['options']['MultipleActiveResultSets'] ?? true,
        ]);
    };

    $conn = $connect($c['database']);
    if ($conn === false && !empty($c['fallback_database'])) {
        // fallback برای محیط‌هایی که جداول BI داخل DarianDW_Dashboard است
        $conn = $connect($c['fallback_database']);
    }

    if ($conn === false) {
        throw new Exception('DB connection failed: ' . json_encode(sqlsrv_errors(), JSON_UNESCAPED_UNICODE));
    }
    return $conn;
}
