<?php
// /api/lookup/l1.php
define('BI_API', true);

require_once __DIR__ . '/../../src/config/db.php';
require_once __DIR__ . '/../../src/helpers/helperFunctions.php';
require_once __DIR__ . '/../../src/helpers/Auth.php';

function clamp_int($v, $min, $max, $def) {
    $n = (int)$v;
    if ($n <= 0) $n = $def;
    if ($n < $min) $n = $min;
    if ($n > $max) $n = $max;
    return $n;
}

try {
    $t0 = microtime(true);
    auth_user(); // فقط لاگین چک شه
    $conn  = db_connect();

    $q = trim((string)get_param('q', ''));
    $limit = clamp_int(get_param('limit', 50), 1, 200, 50);

    $where = "WHERE sd.ProductGroupID IS NOT NULL";
    $params = [];

    if ($q !== '') {
        $where .= " AND sd.ProductGroupTitle LIKE ?";
        $params[] = '%' . $q . '%';
    }

    $sql = "
        SELECT TOP ($limit)
            sd.ProductGroupID AS l1_id,
            MAX(sd.ProductGroupTitle) AS l1_title
        FROM BI.SaleDetail sd WITH (NOLOCK)
        $where
        GROUP BY sd.ProductGroupID
        ORDER BY sd.ProductGroupID ASC
        OPTION (RECOMPILE);
    ";

    $stmt = sqlsrv_query($conn, $sql, $params);
    if ($stmt === false) fail('DB error (lookup l1)', 500, ['sqlsrv_errors' => sqlsrv_errors()]);

    $items = [];
    while ($r = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
        $items[] = [
            'value' => (int)$r['l1_id'],
            'label' => (string)($r['l1_title'] ?? ''),
        ];
    }

    $elapsed_ms = (int)round((microtime(true) - $t0) * 1000);

    json_response([
        'data' => ['items' => $items],
        'meta' => [
            'ok' => true,
            'filters' => ['q' => $q ?: null, 'limit' => $limit],
            'duration_ms' => $elapsed_ms,
            'source' => 'BI.SaleDetail (distinct ProductGroupID/Title)',
        ]
    ]);
} catch (Throwable $e) {
    fail('Server error: ' . $e->getMessage(), 500);
}
