<?php
// /src/helpers/GapGPT.php
if (!defined('BI_API')) { http_response_code(403); exit('Forbidden'); }

require_once __DIR__ . '/helperFunctions.php';

function gapgpt_chat(array $messages, array $opts = []): array
{
    $apiKey = getenv('GAPGPT_API_KEY');
    if (!$apiKey) {
        // اگر env نداری، موقتاً اینجا دستی بذار
        $apiKey = 'PUT_YOUR_API_KEY_HERE';
    }

    $endpoint = 'https://gapgpt.app/api/v1/chat/completions';
    $model = $opts['model'] ?? 'GPT-4o';
    $temperature = isset($opts['temperature']) ? (float)$opts['temperature'] : 0.2;
    $max_tokens = isset($opts['max_tokens']) ? (int)$opts['max_tokens'] : 900;
    $timeout = isset($opts['timeout']) ? (int)$opts['timeout'] : 45;

    $payload = [
        'model' => $model,
        'messages' => $messages,
        'temperature' => $temperature,
        'max_tokens' => $max_tokens,
    ];

    $headers = [
        'Authorization: Bearer ' . $apiKey,
        'Content-Type: application/json',
        'Accept: application/json',
    ];

    $body = json_encode($payload, JSON_UNESCAPED_UNICODE);
    if ($body === false) fail('JSON encode failed (GapGPT payload)', 500);

    $ch = curl_init($endpoint);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POSTFIELDS => $body,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => $timeout,
        CURLOPT_CONNECTTIMEOUT => 10,
    ]);

    $resp = curl_exec($ch);
    $http = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $err  = curl_error($ch);
    curl_close($ch);

    if ($resp === false) {
        fail('GapGPT request failed: ' . ($err ?: 'unknown error'), 502);
    }

    $arr = json_decode($resp, true);
    if (!is_array($arr)) {
        fail('GapGPT returned invalid JSON', 502, ['http_code' => $http, 'raw' => $resp]);
    }

    return ['http_code' => $http, 'json' => $arr];
}
