<?php
// /api/admin/products/approve.php
define('BI_API', true);

require_once __DIR__ . '/../../../src/config/db.php';
require_once __DIR__ . '/../../../src/helpers/helperFunctions.php';
require_once __DIR__ . '/../../../src/helpers/Auth.php';

function read_body_params(): array {
    $ct = strtolower((string)($_SERVER['CONTENT_TYPE'] ?? ''));
    if (strpos($ct, 'application/json') !== false) {
        $raw = file_get_contents('php://input');
        $j = json_decode($raw, true);
        return is_array($j) ? $j : [];
    }
    return $_POST ?: [];
}

function to_int_or_null($v): ?int {
    if ($v === null) return null;
    if ($v === '') return null;
    if (is_int($v)) return $v;
    if (is_string($v) && preg_match('/^\d+$/', $v)) return (int)$v;
    if (is_numeric($v)) return (int)$v;
    return null;
}

try {
    $t0 = microtime(true);

    $user = auth_user();
    $conn = db_connect();

    $body = read_body_params();

    $edit_id = to_int_or_null($body['edit_id'] ?? null);
    if (!$edit_id) fail('edit_id is required', 400);

    $note = trim((string)($body['note'] ?? ''));

    $reviewed_by =
        (string)($user['Username'] ?? $user['UserName'] ?? $user['username'] ?? $user['email'] ?? $user['ID'] ?? 'admin');

    $sql = "EXEC BI.sp_approve_product_edit @EditID = ?, @ReviewedBy = ?, @Note = ?";
    $params = [
        (int)$edit_id,
        $reviewed_by,
        ($note !== '' ? $note : null)
    ];

    $stmt = sqlsrv_query($conn, $sql, $params);
    if ($stmt === false) {
        fail('DB error (approve)', 500, ['sqlsrv_errors' => sqlsrv_errors()]);
    }

    $r = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC) ?: [];

    json_response([
        'data' => [
            'edit_id' => (int)$edit_id,
            'product_id' => isset($r['ProductID']) ? (int)$r['ProductID'] : null,
            'active_version' => isset($r['ActiveVersion']) ? (int)$r['ActiveVersion'] : null,
        ],
        'meta' => [
            'ok' => true,
            'duration_ms' => (int)round((microtime(true) - $t0) * 1000),
            'source' => 'BI.sp_approve_product_edit',
        ]
    ]);

} catch (Throwable $e) {
    fail('Server error: ' . $e->getMessage(), 500);
}
